/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>

#define COOKBOOK_PURPLE_COLOR	[UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) 	[[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]

// Metoda zwraca pełną listę widoków potomnych danego widoku.
NSArray *allSubviews(UIView *aView)
{
	NSArray *results = [aView subviews];
	for (UIView *eachView in [aView subviews])
	{
		NSArray *allViews = allSubviews(eachView);
		if (allViews) 
            results = [results arrayByAddingObjectsFromArray:allViews];
	}
	return results;
}

// Metoda zwraca wszystkie widoki aplikacji.
NSArray *allApplicationViews()
{
    NSArray *results = [[UIApplication sharedApplication] windows];
    for (UIWindow *window in [[UIApplication sharedApplication] windows])
	{
		NSArray *allViews = allSubviews(window);
        if (allViews) 
            results = [results arrayByAddingObjectsFromArray: allViews];
	}
    return results;
}

// Metoda zwraca tablicę widoków nadrzędnych, począwszy od okna aż do wskazanego widoku.
NSArray *pathToView(UIView *aView)
{
    NSMutableArray *array = [NSMutableArray arrayWithObject:aView];
    UIView *view = aView;
    UIWindow *window = aView.window;
    while (view != window)
    {
        view = [view superview];
        [array insertObject:view atIndex:0];
    }
    return array;
}

@interface TestBedViewController : UIViewController
@end

@implementation TestBedViewController

- (void) collectViews: (id) sender
{
	// Dwa podwidoki widoku głównego są obrazami,
	// natomiast etykieta wyświetla wybrany numer.
	printf("Podwidoki widoku głównego:\n");
	NSLog(@"%@", allSubviews(self.view));
	
	printf("Ścieżka do każdego podwidoku:\n");
	for (UIView *eachView in allSubviews(self.view))
		NSLog(@"%@", pathToView(eachView));
	
	// More views than you could dream of! 
	printf("\nWszystkie pod widoki okna:\n");
	NSLog(@"%@", allApplicationViews());
}

-(void) segmentAction: (UISegmentedControl *) sender
{
	// Uaktualnienie etykiety numerem segmentu.
	UILabel *label = (UILabel *)[self.view viewWithTag:101];
	[label setText:[NSString stringWithFormat:@"%0d", sender.selectedSegmentIndex + 1]];
}

- (void) loadView
{
    [super loadView];
    self.view.backgroundColor = [UIColor whiteColor];
    
	self.navigationController.navigationBar.tintColor = COOKBOOK_PURPLE_COLOR;
	self.navigationItem.rightBarButtonItem = BARBUTTON(@"Test", @selector(collectViews:));
    
    // Utworzenie kontrolki segmentowanej. Wybierz jeden z trzech stylów.
	NSArray *buttonNames = [NSArray arrayWithObjects:@"Jeden", @"Dwa", @"Trzy", @"Cztery", @"Pięć", @"Sześć", nil];
	UISegmentedControl* segmentedControl = [[UISegmentedControl alloc] initWithItems:buttonNames];
	segmentedControl.segmentedControlStyle = UISegmentedControlStyleBar; 
	[segmentedControl addTarget:self action:@selector(segmentAction:) forControlEvents:UIControlEventValueChanged];
	segmentedControl.momentary = YES;
	self.navigationItem.titleView = segmentedControl;	
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [application setStatusBarHidden:YES];
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}